@echo off
setlocal

echo Installing Desk Shot...
echo.

:: Define the paths
set "SCRIPT_DIR=%~dp0"
set "EXE_PATH=%SCRIPT_DIR%Desk Shot.exe"
set "ICON_PATH=%SCRIPT_DIR%deskshot.ico"
set "STARTUP_DIR=%APPDATA%\Microsoft\Windows\Start Menu\Programs\Startup"
set "DESKTOP=%USERPROFILE%\Desktop"

:: Check if Desk Shot.exe exists
if not exist "%EXE_PATH%" (
    echo ERROR: Desk Shot.exe not found in current directory.
    echo Please make sure this file is in the same folder as Desk Shot.exe
    pause
    exit /b 1
)

:: Add to Startup using VBScript to create a shortcut
echo Adding Desk Shot to Startup...
set "STARTUP_SHORTCUT=%STARTUP_DIR%\Desk Shot.lnk"

:: Create VBScript to make the startup shortcut
echo Set oWS = WScript.CreateObject("WScript.Shell") > "%TEMP%\CreateShortcut.vbs"
echo sLinkFile = "%STARTUP_SHORTCUT%" >> "%TEMP%\CreateShortcut.vbs"
echo Set oLink = oWS.CreateShortcut(sLinkFile) >> "%TEMP%\CreateShortcut.vbs"
echo oLink.TargetPath = "%EXE_PATH%" >> "%TEMP%\CreateShortcut.vbs"
echo oLink.WorkingDirectory = "%SCRIPT_DIR%" >> "%TEMP%\CreateShortcut.vbs"
if exist "%ICON_PATH%" (
    echo oLink.IconLocation = "%ICON_PATH%" >> "%TEMP%\CreateShortcut.vbs"
)
echo oLink.Save >> "%TEMP%\CreateShortcut.vbs"

cscript //nologo "%TEMP%\CreateShortcut.vbs"
del "%TEMP%\CreateShortcut.vbs"

if exist "%STARTUP_SHORTCUT%" (
    echo Successfully added to Startup.
) else (
    echo WARNING: Failed to add to Startup.
)

echo.

:: Create Desktop shortcut using VBScript
echo Creating Desktop shortcut...
set "DESKTOP_SHORTCUT=%DESKTOP%\Desk Shot.lnk"

:: Create VBScript to make the desktop shortcut
echo Set oWS = WScript.CreateObject("WScript.Shell") > "%TEMP%\CreateShortcut.vbs"
echo sLinkFile = "%DESKTOP_SHORTCUT%" >> "%TEMP%\CreateShortcut.vbs"
echo Set oLink = oWS.CreateShortcut(sLinkFile) >> "%TEMP%\CreateShortcut.vbs"
echo oLink.TargetPath = "%EXE_PATH%" >> "%TEMP%\CreateShortcut.vbs"
echo oLink.WorkingDirectory = "%SCRIPT_DIR%" >> "%TEMP%\CreateShortcut.vbs"
if exist "%ICON_PATH%" (
    echo oLink.IconLocation = "%ICON_PATH%" >> "%TEMP%\CreateShortcut.vbs"
)
echo oLink.Description = "Desk Shot - Screenshot Capture Tool" >> "%TEMP%\CreateShortcut.vbs"
echo oLink.Save >> "%TEMP%\CreateShortcut.vbs"

cscript //nologo "%TEMP%\CreateShortcut.vbs"
del "%TEMP%\CreateShortcut.vbs"

if exist "%DESKTOP_SHORTCUT%" (
    echo Successfully created Desktop shortcut.
) else (
    echo WARNING: Failed to create Desktop shortcut.
)

echo.
echo Installation complete!
echo Desk Shot has been added to Startup and a shortcut has been created on your Desktop.
echo.

pause